/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.HighResolutionSeconds;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.Time2ProtectionParameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.Timer;
import java.util.Random;

public class RandomParameter
extends Time2ProtectionParameter {
    static final long serialVersionUID = 0L;
    private int serializedDataVersion = 1;
    private Random randomObj;

    public RandomParameter() {
    }

    public RandomParameter(Block block) {
        super(block);
        this.fParameter = 2;
        this.fData = 1;
        this.fAllocatedTimer = 1;
        this.setParameterNameKeys();
    }

    public TimeUnit getRestTimeH() {
        if (this.fState == 1) {
            TimeUnit tu = this.getCurrentTimer().getRemainingTimeForShowing();
            return tu.convertTo(TimeUnit.getNewTimeObject(this.getHTimer().getParamTime().getUnitKey()));
        }
        return TimeUnit.getNewTimeObject(this.getHTimer().getParamTime().getUnitKey());
    }

    public TimeUnit getRestTimeL() {
        if (this.fState == 2) {
            TimeUnit tu = this.getCurrentTimer().getRemainingTimeForShowing();
            return tu.convertTo(TimeUnit.getNewTimeObject(this.getLTimer().getParamTime().getUnitKey()));
        }
        return TimeUnit.getNewTimeObject(this.getLTimer().getParamTime().getUnitKey());
    }

    public boolean calculateValue(boolean trg) {
        boolean result = false;
        switch (this.fState) {
            case 0: {
                if (!trg) break;
                long time = this.getRandom(this.getHTimer().getParamTime().getMilliseconds());
                this.getCurrentTimer().getParamTime().setMilliseconds(time);
                this.getCurrentTimer().start();
                this.fState = 1;
                break;
            }
            case 1: {
                if (trg) {
                    if (!this.fTimer.isFinished()) break;
                    this.fState = 3;
                    result = true;
                    break;
                }
                this.fState = 0;
                this.fTimer.reset();
                break;
            }
            case 3: {
                if (!trg) {
                    long time = this.getRandom(this.getLTimer().getParamTime().getMilliseconds());
                    this.getCurrentTimer().getParamTime().setMilliseconds(time);
                    this.getCurrentTimer().start();
                    this.fState = 2;
                }
                result = true;
                break;
            }
            case 2: {
                if (!trg) {
                    if (this.fTimer.isFinished()) {
                        this.fState = 0;
                        this.fTimer.reset();
                        break;
                    }
                    result = true;
                    break;
                }
                this.fState = 0;
                this.fTimer.reset();
            }
        }
        return result;
    }

    public long getRandom(long max) {
        double rand = Math.random();
        return Math.round((double)max * rand);
    }

    protected void setParameterNameKeys() {
        this.getHTimer().setNameKey("dialog.parameter.random.th");
        this.getLTimer().setNameKey("dialog.parameter.random.tl");
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.fTimer = new Timer(new HighResolutionSeconds());
        this.fTimer.init(interpreter);
    }
}

